/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	ReverseAxes.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "CWorkplane.h"
#include "cApplication.h"


HRESULT ReverseAxes(IDirection **retval1, IDirection **retval2)
{
	START_METHOD("ReverseAxes")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// get the local X
	IDirection *pLocalX = NULL;
	status = activeWorkplane->GetLocalX(&pLocalX);
	CHECK_RETURN_STATUS(status)

	// change the direction of x to negative
	IVector *pNewLocalX = NULL;
	status = pLocalX->GetNegative(&pNewLocalX);
	CHECK_RETURN_STATUS(status)

	double localXDirX, localXDirY, localXDirZ;
	status = pNewLocalX->GetAt(0, &localXDirX);
	CHECK_RETURN_STATUS(status)

	status = pNewLocalX->GetAt(1, &localXDirY);
	CHECK_RETURN_STATUS(status)

	status = pNewLocalX->GetAt(2, &localXDirZ);
	CHECK_RETURN_STATUS(status)

	IDirection *pLocalXDir = NULL;
	status = (GetCLASS(Direction))->CreateDirection(localXDirX, localXDirY, localXDirZ, &pLocalXDir);
	CHECK_RETURN_STATUS(status)

	IDirection *pLocalY = NULL;
	status = activeWorkplane->GetLocalY(&pLocalY);
	CHECK_RETURN_STATUS(status)

	// set Local Axes
	status = activeWorkplane->SetLocalAxes(pLocalXDir, pLocalY);
	CHECK_RETURN_STATUS(status)

	*retval1 = pLocalXDir;
	*retval2 = pLocalY;

	END_METHOD("ReverseAxes")
}
